#ifndef _DLT645_COMM_H_
#define _DLT645_COMM_H_

#define MAX_IEC1107_MSG_BODY        66

#define DLT645_MSG_RX_START_BODY    10
#define DLT645_MSG_RX_START_BODY_W  5
#define DLT645_MSG_TX_START_BODY    14
#define DLT645_MSG_TX_START_BODY_W  7
#define MAX_DLT645_MSG_BODY         66

typedef union
{
#if 0
    uint8_t uint8[4 + 12 + 256];
    uint16_t uint16[(4 + 12 + 256)/2];
#else
    uint8_t uint8[4 + 12 + MAX_IEC1107_MSG_BODY];
    uint16_t uint16[(4 + 12 + MAX_IEC1107_MSG_BODY)/2];
#endif
} serial_msg_t;

/* Incoming or outgoing serial message buffer */
typedef struct
{
    serial_msg_t buf;
    uint8_t ptr;
    uint8_t len;
    uint8_t inter_char_timeout;
} serial_msg_buf_t;

extern void dlt645_rx_byte(int port, uint8_t ch);
extern int prepare_tx_message(int port, int len);
extern serial_msg_buf_t tx_msg[];
extern serial_msg_buf_t rx_msg[];

#endif

